'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Public Sub KategorieVorgabeliste_Aktualisieren()
    'Aktualisiert die interne Kategorie-Vorgabeliste anhand einer externen Datei
    
    Dim dbs As Database
    Dim rst As Recordset
    Dim Filter As String
    
    Dim DateiSuche As String
    Dim fs As Object
    Dim tf As Object
    Dim Meldung As String
    Dim ZeilenNummer As Integer
    Dim Text As String
    Dim TStart As Integer
    Dim TEnde As Integer
    Dim FeldNr As Integer
    Dim FeldNichtDa As Boolean
    
    
    'Prfung, ob angegebene Datei vorhanden ist
    DateiSuche = ""
    On Error Resume Next                    'Meldung "Pfad nicht gefunden" unterdrcken!
    DateiSuche = Dir(KatListeDatei)
    'On Error GoTo Err_....     'Fehlerbehandlung wieder einschalten
    If (DateiSuche = "") Then               'Datei auch vorhanden?
        Meldung = "Die in den Einstellungen angegebene Textdatei mit den Kategorievorgaben wurde nicht gefunden."
        Meldung = Meldung & vbNewLine & vbNewLine & "Die interne Liste mit Kategorievorgaben wird nicht aktualisiert."
        MsgBox Meldung, vbOKOnly + vbExclamation, "Achtung"
        Exit Sub
    End If
    
    'brige Parameter prfen
    If (KatWoVon < 0) Or (KatWoVon > 250) Then
        Meldung = "Die in den Einstellungen hinterlegte Beginnposition fr die Kategorienamen in der externen Kategorieliste liegt nicht zwischen 0 und 250."
        Meldung = Meldung & vbNewLine & vbNewLine & "Die interne Liste mit Kategorievorgaben wird nicht aktualisiert."
        MsgBox Meldung, vbOKOnly + vbExclamation, "Achtung"
        Exit Sub
    End If

    If KatOrt = "P" Then
        'KatOrt ist "P"-osition
        If (KatWoBis < 0) Or (KatWoBis > 250) Then
            Meldung = "Die in den Einstellungen hinterlegte Endeposition fr die Kategorienamen in der externen Kategorieliste liegt nicht zwischen 0 und 250."
            Meldung = Meldung & vbNewLine & vbNewLine & "Die interne Liste mit Kategorievorgaben wird nicht aktualisiert."
            MsgBox Meldung, vbOKOnly + vbExclamation, "Achtung"
            Exit Sub
        End If
        If KatWoBis < KatWoVon Then
            Meldung = "Die in den Einstellungen hinterlegte Endeposition fr die Kategorienamen in der externen Kategorieliste ist kleiner als die hinterlegte Beginnposition."
            Meldung = Meldung & vbNewLine & vbNewLine & "Die interne Liste mit Kategorievorgaben wird nicht aktualisiert."
            MsgBox Meldung, vbOKOnly + vbExclamation, "Achtung"
            Exit Sub
        End If
    End If
    
    
    On Error GoTo ERR_Kat_DateiOeffnen
    
    'Datei mit Kategorievorgaben ffnen
    Set fs = CreateObject("Scripting.FileSystemObject")
    Set tf = fs.OpenTextFile(KatListeDatei, 1, False)           'fs.OpenTextFile(KatListeDatei, 1 = ForReading, False = nicht erstellen[falls nicht vorhanden])
    
    
    'Alle Zeilen der Textdatei durchgehen
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset("SELECT * FROM Kategorievorgaben ORDER BY Kategorie")
    
    ZeilenNummer = 1                        'wird fr evtl. Fehlermeldung bentigt
    Do While tf.AtEndOfStream <> True
        On Error GoTo ERR_Kat_ZeileLesen
        Text = tf.ReadLine
        
        On Error GoTo ERR_Kat_Feldposition
        
        FeldNichtDa = False
        If KatOrt = "P" Then
            'Position der Kategore durch feste P-osition festgelegt durch Von-Bis
            'Sonderfall: Von- und Bis-Wert sind 0
            If (KatWoVon = 0) And (KatWoBis = 0) Then
                'nichts zu tun, denn die gesamte Textzeile wird als Kategoriebezeichnung gewertet
            Else
                If KatWoVon = 0 Then
                    Text = Mid(Text, 1, KatWoBis)
                Else
                    Text = Mid(Text, KatWoVon, KatWoBis - KatWoVon + 1)
                End If
            End If
        Else
            'Position der Kategorie durch D-atenfeld xy festgelegt
            'Sonderfall: Von- und Bis-Wert sind 0
            If (KatWoVon = 0) And (KatWoBis = 0) Then
                'nichts zu tun, denn die gesamte Textzeile wird als Kategoriebezeichnung gewertet
            Else
                'Ermittlung der Startposition
                If KatWoVon < 2 Then        'bei 0 oder 1
                    TStart = 1
                Else
                    TStart = 1
                    For FeldNr = 1 To (KatWoVon - 1)
                        If InStr(TStart, Text, KatTrennzeichen) = 0 Then
                            'Position des nchsten erwarteten Trennzeichens nicht mehr gefunden
                            '-> Feld existiert nicht
                            FeldNichtDa = True
                            Exit For
                        Else
                            TStart = InStr(TStart, Text, KatTrennzeichen) + 1
                        End If
                    Next FeldNr
                End If
                'Ermittlung der Endeposition
                If FeldNichtDa = False Then
                    If InStr(TStart, Text, KatTrennzeichen) = 0 Then
                        'letztes Datenfeld
                        TEnde = Len(Text)
                    Else
                        TEnde = InStr(TStart, Text, KatTrennzeichen) - 1
                    End If
                End If
            End If
            Text = Mid(Text, TStart, TEnde - TStart + 1)
        End If
        If FeldNichtDa = True Then
            Meldung = "In der externen Datei mit den Kategorievorgaben " & vbNewLine & "enthlt Zeile " & ZeilenNummer & " kein " & KatWoVon & ". Datenfeld."
            Meldung = Meldung & vbNewLine & vbNewLine & "Die Aktualisierung der internen Liste mit externen Kategorievorgaben wird mit der nchsten Zeile fortgesetzt."
            MsgBox Meldung, vbOKOnly + vbExclamation, "Achtung"
        Else
            
            Text = Trim(Text)
            'evtl. Anfhrungszeichen am Anfang und Ende beseitigen
            If LCase(KatAnfuehrung) <> "keine" Then
                'am Anfang
                If Left(Text, 1) = KatAnfuehrung Then
                    If Len(Text) = 1 Then
                        Text = ""
                    Else
                        Text = Mid(Text, 2)
                    End If
                End If
                'am Ende
                If Right(Text, 1) = KatAnfuehrung Then
                    If Len(Text) = 1 Then
                        Text = ""
                    Else
                        Text = Left(Text, Len(Text) - 1)
                    End If
                End If
            End If
            Text = Trim(Text)
            
            On Error GoTo ERR_Kat_EinfuegenFehler
            
            If Text <> "" Then
                'Kategoriebezeichnung in die Vorgabenliste bernehmen
                Filter = "[Kategorie]=""" & Text & """"
                rst.FindFirst (Filter)
                If rst.NoMatch Then
                    rst.AddNew
                    rst!Kategorie = Text
                    rst!Kz = 0
                    rst.Update
                End If
            End If
            
        End If      'FeldNichtDa = true
        
        ZeilenNummer = ZeilenNummer + 1
    Loop            'nchste Zeile
    
    
ERR_Kat_DB_Schliessen:
    'Datenbank wieder schlieen
    rst.Close
    dbs.Close

ERR_Kat_DateiSchliessen:
    'Datei mit Kategorievorgaben wieder schlieen
    tf.Close                ' Textfile schlieen
    Set fs = Nothing        ' FileSystemObject schlieen
    
ERR_Kat_Ende:
    Exit Sub
    
    
    
    
    
ERR_Kat_EinfuegenFehler:
    Meldung = "Die Kategorie der Zeile " & ZeilenNummer & " der externen Kategorievorgaben konnte nicht in die interne Liste eingefgt werden."
    Meldung = Meldung & vbNewLine & vbNewLine & "Die Aktualisierung der internen Liste mit Kategorievorgaben wird abgebrochen."
    MsgBox Meldung, vbOKOnly + vbExclamation, "Achtung"
    MsgBox err.Description
    Resume ERR_Kat_DB_Schliessen

ERR_Kat_Feldposition:
    Meldung = "In der externen Datei mit den Kategorievorgaben trat ein Fehler bei der Ermittlung der Datenfeldposition auf."
    Meldung = Meldung & vbNewLine & vbNewLine & "Die Aktualisierung der internen Liste mit Kategorievorgaben wird abgebrochen."
    MsgBox Meldung, vbOKOnly + vbExclamation, "Achtung"
    MsgBox err.Description
    Resume ERR_Kat_DateiSchliessen
    
ERR_Kat_ZeileLesen:
    Meldung = "In der externen Datei mit den Kategorievorgaben konnte die Zeile " & ZeilenNummer & " nicht gelesen werden."
    Meldung = Meldung & vbNewLine & vbNewLine & "Die Aktualisierung der internen Liste mit Kategorievorgaben wird abgebrochen."
    MsgBox Meldung, vbOKOnly + vbExclamation, "Achtung"
    MsgBox err.Description
    Resume ERR_Kat_DateiSchliessen

ERR_Kat_DateiOeffnen:
    Meldung = "Die in den Einstellungen hinterlegte Datei fr die Kategorievorgaben wurde zwar gefunden, konnte aber nicht geffnet werden."
    Meldung = Meldung & vbNewLine & vbNewLine & "Die interne Liste mit Kategorievorgaben wird nicht aktualisiert."
    MsgBox Meldung, vbOKOnly + vbExclamation, "Achtung"
    MsgBox err.Description
    Resume ERR_Kat_Ende


End Sub

Public Sub KategorienVonOutlook()
    '======================= erst ab OL_2007 ===============================
    'Gleicht die Kategorien in der TA mit den Farb-Kategorien von Outlook ab
    
    Dim FilterKategorie As String
    Dim Kategorie As Object
    Dim IDvorhanden As Boolean
    Dim NameVorhanden As Boolean
    Dim KategorieUebernehmen As Boolean
    Dim KategorieVorgabeFilter As String
    
    Dim KategorieAnzahlGesamt As Long
    Dim KategorieAnzahlAktuell As Long
    
    
    'Prfen, ob die Kategorievorgabeliste vorher noch aus einer Textdatei aktualisiert werden soll
    If KatAutoEinlesen = True Then
        Forms!Outlook_einlesen.Meldungsfeld.Caption = "Kategorievorgaben aktualisieren..."
        Forms!Outlook_einlesen.Repaint
        
        Call KategorieVorgabeliste_Aktualisieren
    End If
        
        
    Forms!Outlook_einlesen.Meldungsfeld.Caption = "Kategorien von Outlook bernehmen..."
    Forms!Outlook_einlesen.Repaint
    
    If meinNamespace.Categories.Count > 0 Then
    
        'Pro Forma schon die Kategorie-Vorgabeliste ffnen
        Set rstKatVorgabe = dbs.OpenRecordset("SELECT * FROM Kategorievorgaben ORDER BY Kategorie")
        
        
        KategorieAnzahlAktuell = 0
        KategorieAnzahlGesamt = meinNamespace.Categories.Count
        
        Forms!Outlook_einlesen.KategorieNummerAktuell.Caption = KategorieAnzahlAktuell & " von " & KategorieAnzahlGesamt
        Forms!Outlook_einlesen.Repaint
    
        For Each Kategorie In meinNamespace.Categories
            
            'Prfung, ob alle Kategorien bernommen werden sollen oder nur die der Vorgabeliste.
            'Wenn Vorgabeliste, dann Prfung, ob die Outlook-Kategorie vom Namen in der Liste ist.
            KategorieUebernehmen = True
            If KatUebernahmeArt = 1 Then                        ' 1 = nur die Kategorien der Vorgabeliste
                KategorieVorgabeFilter = "[Kategorie]=""" & Kategorie.Name & """"
                rstKatVorgabe.FindFirst (KategorieVorgabeFilter)
                If rstKatVorgabe.NoMatch Then
                    KategorieUebernehmen = False
                End If
            End If
            
            If KategorieUebernehmen = True Then
            
                ' 1. Prfung auf vorhandene ID
                FilterKategorie = "SELECT * FROM Kategorien WHERE [Kategorie_ID]='" & Kategorie.CategoryID & "'"
                Set rstKategorien = dbs.OpenRecordset(FilterKategorie)
                IDvorhanden = False
                If (rstKategorien.RecordCount > 0) Then
                    IDvorhanden = True
                End If
                rstKategorien.Close
                ' wenn ID noch nicht in der TA, dann
                ' 2. Prfung auf vorhandenen Namen
                FilterKategorie = "SELECT * FROM Kategorien WHERE [Name1]='" & Kategorie.Name & "'"
                Set rstKategorien = dbs.OpenRecordset(FilterKategorie)
                NameVorhanden = False
                If (rstKategorien.RecordCount > 0) Then
                    NameVorhanden = True
                End If
                rstKategorien.Close
                
                FilterKategorie = "SELECT * FROM Kategorien WHERE [Kategorie_ID]='" & Kategorie.CategoryID & "'"
                If NameVorhanden Then
                    FilterKategorie = "SELECT * FROM Kategorien WHERE [Name1]='" & Kategorie.Name & "'"
                End If
                
                Set rstKategorien = dbs.OpenRecordset(FilterKategorie)
                If (rstKategorien.RecordCount = 0) Then
                    ' Kategorie neu anlegen
                    rstKategorien.AddNew
                    rstKategorien!Preis_indiv = False
                    rstKategorien!MwSt_indiv = False
                    rstKategorien!MwSteuer = 0
                Else
                    'vorhandene Kategorie aktualisieren
                    rstKategorien.MoveLast               'auffllen
                    rstKategorien.MoveFirst
                    rstKategorien.Edit
                End If
                'Werte von Outlook bernehmen
                rstKategorien!Kategorie_ID = Kategorie.CategoryID
                rstKategorien!Name1 = Kategorie.Name
                rstKategorien!FarbNr = Kategorie.Color
                Select Case Kategorie.Color
                    Case 1
                        rstKategorien!Rot = 231
                        rstKategorien!Gruen = 162
                        rstKategorien!Blau = 165
                    Case 2
                        rstKategorien!Rot = 255
                        rstKategorien!Gruen = 186
                        rstKategorien!Blau = 140
                    Case 3
                        rstKategorien!Rot = 247
                        rstKategorien!Gruen = 223
                        rstKategorien!Blau = 140
                    Case 4
                        rstKategorien!Rot = 255
                        rstKategorien!Gruen = 251
                        rstKategorien!Blau = 148
                    Case 5
                        rstKategorien!Rot = 123
                        rstKategorien!Gruen = 211
                        rstKategorien!Blau = 107
                    Case 6
                        rstKategorien!Rot = 156
                        rstKategorien!Gruen = 223
                        rstKategorien!Blau = 206
                    Case 7
                        rstKategorien!Rot = 198
                        rstKategorien!Gruen = 211
                        rstKategorien!Blau = 181
                    Case 8
                        rstKategorien!Rot = 156
                        rstKategorien!Gruen = 182
                        rstKategorien!Blau = 239
                    Case 9
                        rstKategorien!Rot = 181
                        rstKategorien!Gruen = 162
                        rstKategorien!Blau = 231
                    Case 10
                        rstKategorien!Rot = 222
                        rstKategorien!Gruen = 174
                        rstKategorien!Blau = 198
                    Case 11
                        rstKategorien!Rot = 222
                        rstKategorien!Gruen = 219
                        rstKategorien!Blau = 222
                    Case 12
                        rstKategorien!Rot = 107
                        rstKategorien!Gruen = 121
                        rstKategorien!Blau = 148
                    Case 13
                        rstKategorien!Rot = 189
                        rstKategorien!Gruen = 190
                        rstKategorien!Blau = 189
                    Case 14
                        rstKategorien!Rot = 107
                        rstKategorien!Gruen = 109
                        rstKategorien!Blau = 107
                    Case 15
                        rstKategorien!Rot = 74
                        rstKategorien!Gruen = 77
                        rstKategorien!Blau = 74
                    Case 16
                        rstKategorien!Rot = 198
                        rstKategorien!Gruen = 24
                        rstKategorien!Blau = 33
                    Case 17
                        rstKategorien!Rot = 231
                        rstKategorien!Gruen = 97
                        rstKategorien!Blau = 8
                    Case 18
                        rstKategorien!Rot = 198
                        rstKategorien!Gruen = 154
                        rstKategorien!Blau = 49
                    Case 19
                        rstKategorien!Rot = 198
                        rstKategorien!Gruen = 178
                        rstKategorien!Blau = 0
                    Case 20
                        rstKategorien!Rot = 49
                        rstKategorien!Gruen = 142
                        rstKategorien!Blau = 41
                    Case 21
                        rstKategorien!Rot = 49
                        rstKategorien!Gruen = 154
                        rstKategorien!Blau = 123
                    Case 22
                        rstKategorien!Rot = 115
                        rstKategorien!Gruen = 138
                        rstKategorien!Blau = 66
                    Case 23
                        rstKategorien!Rot = 41
                        rstKategorien!Gruen = 89
                        rstKategorien!Blau = 165
                    Case 24
                        rstKategorien!Rot = 90
                        rstKategorien!Gruen = 60
                        rstKategorien!Blau = 165
                    Case 25
                        rstKategorien!Rot = 148
                        rstKategorien!Gruen = 69
                        rstKategorien!Blau = 107
                    Case Else
                        rstKategorien!Rot = 255      '(wei)
                        rstKategorien!Gruen = 255
                        rstKategorien!Blau = 255
                End Select
                rstKategorien.Update
                rstKategorien.Close
            
            End If          'KategorieUebernehmen = True
            
            'Fortschrittsanzeige
            If KategorieUebernehmen = True Then
                KategorieAnzahlAktuell = KategorieAnzahlAktuell + 1
            End If
            Forms!Outlook_einlesen.KategorieNummerAktuell.Caption = KategorieAnzahlAktuell & " von " & KategorieAnzahlGesamt
            Forms!Outlook_einlesen.Repaint
            
            
        Next        'Outlook-Kategorie
        
        
        'Kategorie-Vorgabeliste wieder schlieen
        rstKatVorgabe.Close
        
        
        Forms!Outlook_einlesen.KategorieNummerAktuell.Caption = KategorieAnzahlAktuell
        Forms!Outlook_einlesen.Repaint
        
    End If          'Categories.Count > 0
    
End Sub

Public Sub Kategorien_Loeschen()
    ' Lscht alle Kategorien, die keinerlei Verwendung in anderen Tabellen haben
    '----> Routine befindet sich in der Maske Outlook_einlesen!
End Sub
